/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.main.network;

import dev.terminalmc.clientsort.main.MainSort;
import dev.terminalmc.clientsort.main.network.ServerboundSortPacket;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class LogicalServerNetworking {
    private LogicalServerNetworking() {
    }

    public static void onSortPayload(ServerboundSortPacket packet, MinecraftServer server, class_3222 player) {
        if (packet == null) {
            MainSort.LOG.warn("Failed to read sort packet from player {}!", player);
            return;
        }
        if (player.field_7512 == null) {
            MainSort.LOG.warn("Player {} tried to sort inventory without having an open container!", player);
            return;
        }
        if (packet.syncId == player.field_7498.field_7763) {
            server.execute(() -> LogicalServerNetworking.sort((class_1657)player, (class_1703)player.field_7498, packet.slotMapping));
        } else if (packet.syncId == player.field_7512.field_7763) {
            server.execute(() -> LogicalServerNetworking.sort((class_1657)player, player.field_7512, packet.slotMapping));
        }
    }

    private static void sort(class_1657 player, class_1703 screenHandler, int[] slotMapping) {
        if (!LogicalServerNetworking.validMapping(player, screenHandler, slotMapping)) {
            MainSort.LOG.warn("Sort payload from player {} contains invalid data, ignoring!", player);
            return;
        }
        List<class_1799> stacks = screenHandler.field_7761.stream().map(class_1735::method_7677).toList();
        for (int i = 0; i < slotMapping.length; i += 2) {
            int originSlotId = slotMapping[i];
            int destSlotId = slotMapping[i + 1];
            ((class_1735)screenHandler.field_7761.get(destSlotId)).method_48931(stacks.get(originSlotId));
        }
    }

    private static boolean validMapping(class_1657 player, class_1703 screenHandler, int[] slotMapping) {
        int i;
        if (slotMapping.length < 4) {
            MainSort.LOG.warn("Sort payload contains too few slots!", new Object[0]);
            return false;
        }
        IntAVLTreeSet requestedSlots = new IntAVLTreeSet();
        if (!LogicalServerNetworking.validSlotId(screenHandler, slotMapping[0])) {
            return false;
        }
        class_1735 firstSlot = (class_1735)screenHandler.field_7761.get(slotMapping[0]);
        class_1263 targetInv = firstSlot.field_7871;
        for (i = 0; i < slotMapping.length; i += 2) {
            int originSlotId = slotMapping[i];
            int destSlotId = slotMapping[i + 1];
            if (!LogicalServerNetworking.validSlot(screenHandler, originSlotId, targetInv)) {
                return false;
            }
            if (!requestedSlots.add(originSlotId)) {
                MainSort.LOG.warn("Sort payload contains duplicate origin slot {}!", originSlotId);
                return false;
            }
            if (!LogicalServerNetworking.validSlot(screenHandler, destSlotId, targetInv)) {
                return false;
            }
            if (originSlotId == destSlotId) continue;
            class_1735 originSlot = screenHandler.method_7611(originSlotId);
            if (!originSlot.method_7674(player)) {
                MainSort.LOG.warn("Player {} tried to sort slot {}, but that slot doesn't allow taking items!", player, originSlotId);
                return false;
            }
            class_1735 destSlot = screenHandler.method_7611(destSlotId);
            if (destSlot.method_7680(originSlot.method_7677())) continue;
            MainSort.LOG.warn("Player {} tried to sort slot {}, but that slot doesn't allow inserting the origin stack!", player, destSlotId);
            return false;
        }
        for (i = 1; i < slotMapping.length; i += 2) {
            int destSlotId = slotMapping[i];
            if (requestedSlots.remove(destSlotId)) continue;
            MainSort.LOG.warn("Sort payload contains duplicate destination slot or slot without origin: {}!", i);
            return false;
        }
        if (!requestedSlots.isEmpty()) {
            MainSort.LOG.error("Invalid state during checking sort payload, please report this to the {} developer. Requested slots: {}", "ClientSort", requestedSlots);
            return false;
        }
        return true;
    }

    private static boolean validSlotId(class_1703 screenHandler, int slotId) {
        if (slotId < 0 || slotId >= screenHandler.field_7761.size()) {
            MainSort.LOG.warn("Sort payload contains invalid slot id {} out of bounds for length {}!", slotId, screenHandler.field_7761.size());
            return false;
        }
        return true;
    }

    private static boolean validSlot(class_1703 screenHandler, int slotId, class_1263 targetInv) {
        if (!LogicalServerNetworking.validSlotId(screenHandler, slotId)) {
            return false;
        }
        class_1735 slot = screenHandler.method_7611(slotId);
        if (targetInv != slot.field_7871) {
            MainSort.LOG.warn("Sort payload contains slots from different inventories, first: {}, now: {}!", targetInv, slot.field_7871);
            return false;
        }
        return true;
    }
}

